<SCRIPT Language="JavaScript" runat="Server">
// Object Transfer
// by Michael Garnett (mg01@webpickles.com)
/////////////////////////////////////////////////////////////////

@if (! @ObjectTransferSupportIncluded)
	@set @ObjectTransferSupportIncluded = true


/////////////////////////////////////////////////////////////////
//////////////////// BEGIN CLIENT+SERVER ////////////////////////
// Functions in this section are the same in files
// ObjectTransfer.htm and ObjectTransferSupport.asp
// Common version 1.8
	
function otMakeParameter (value) {
	return escape(otMakePackage(value));
}

function otDecodeParameter (txtPackage) {
	if (txtPackage == null)
		return null;
	return otDecodePackage(unescape(txtPackage));
}

function otMakePackage(value) {
	return OT__Encode(value);
}

function otDecodePackage(txtPackage) {
	return eval(txtPackage);
}

///////////////////////////////////////////////
var OT__OIndex, OT__UndefinedExists, OT__ArrayCtor, OT__BooleanCtor, OT__DateCtor;
var OT__NumberCtor, OT__StringCtor;
function OT__BeginEncoding() {
	OT__OIndex = 0;
	OT__UndefinedExists = false;
	if (OT__ArrayCtor == null) {
		OT__ArrayCtor = Array.toString();
		OT__BooleanCtor = Boolean.toString();
		OT__DateCtor = Date.toString();
		OT__NumberCtor = Number.toString();
		OT__StringCtor = String.toString();
	}
}
function OT__EndEncoding(v) {
	if (v != null && typeof(v) == 'object' && v.__otName__ != null) {
		delete v.__otName__;
		for (i in v) {
			OT__EndEncoding(v[i]);
		}
	}
}
function OT__NextObjectID() {
	return OT__OIndex++;
}
function OT__NextObjectName() {
	return 'o' + OT__NextObjectID();
}
function OT__EncodeDeclaration (v) {
	var t = typeof(v);
	if (t == 'object' && t != null) {
		return OT__EncodeConstructedDeclaration(v);
	} else if (t == 'undefined') {
		if (! OT__UndefinedExists) {
			OT__UndefinedExists = true;
			return 'var u';
		}
	}
	return '';
}
function OT__EncodeConstructedDeclaration(v) {
	if (v == null || typeof(v.constructor) == 'undefined')
		return '';
	var t = v.constructor.toString();
	var ret = '';
	if (t == OT__DateCtor || t == OT__NumberCtor || t == OT__StringCtor || t == OT__BooleanCtor)
		return '';
	return OT__EncodeObjectDeclaration (v, t==OT__ArrayCtor);
}

function OT__FormatIndex(i) {
	var result, ix = parseInt(i), needsQuotes = false;
	if (isNaN(ix) || ix.toString()!=i) {
		ix = i;
		needsQuotes = true;
	}
	if (needsQuotes) {
		result = escape(ix);
		if (result == ix)
			result = '"' + result + '"';
		else
			result = 'unescape("' + result + '")';
	} else {
		result = ix.toString();
	}
	return result;
}
function OT__ArrayIsSimple(v) {
	var i = 0;
	for (var ix in v) {
		if (i != ix) {
			return false;
		}
		i++;
	}
	return true;
}
function OT__PropertyIsEncodable(p) {
	switch (p) {
		case '__otName__':
		case '__otInProgress__':
		case '__otFullSyntax__':
		case '__unevalProperties':
			return false;
		default:
			return true;
	}
}	
function OT__EncodeObjectDeclaration (v, bIsArray) {
	if (v.__otName__ == null) {
		if (bIsArray && !OT__ArrayIsSimple(v)) {
			v.__otFullSyntax__ = true;
		}
		v.__otName__ = OT__NextObjectName();
		v.__otInProgress__ = true;
		var decls = new Array;
		var vals = new Array;
		var encodedProps = new Array;
		if (typeof(v.__unevalProperties) == 'object') {
			var props = v.__unevalProperties;
			for (var pi=0; pi<props.length; pi++) {
				if (OT__PropertyIsEncodable(props[pi])) {
					encodedProps[encodedProps.length] = props[pi];
					var decl = OT__EncodeDeclaration(v[props[pi]]);
					if (decl.length > 0)
						decls[decsl.length] = decl;
					vals[vals.length] = OT__EncodeValue(v[props[pi]]);
				}
			}
		} else {
			for (var i in v) {
				if (OT__PropertyIsEncodable(i)) {
					encodedProps[encodedProps.length] = i;
					var decl = OT__EncodeDeclaration(v[i]);
					if (decl.length > 0)
						decls[decls.length] = decl;
					vals[vals.length] = OT__EncodeValue(v[i]);
				}
			}
		}
		var finalVals;
		if (bIsArray && !v.__otFullSyntax__) {
			finalVals = vals;
		} else {
			finalVals = new Array;
			for (var pi=0; pi<encodedProps.length; pi++) {
				var prop = encodedProps[pi];
				var aVal = vals[finalVals.length];
				if (v.__otFullSyntax__) {
					finalVals[finalVals.length] = v.__otName__ + '[' + OT__FormatIndex(prop) + ']=' + aVal;
				} else {
					finalVals[finalVals.length] = '"' + prop + '":' + aVal;
				}
			}
		}
		var declString = '';
		if (decls.length > 0)
			declString = decls.join(';') + ';';
		var ret;
		if (v.__otFullSyntax__) {
			ret = 'var ' + v.__otName__ + '=new ';
			ret += (bIsArray ? 'Array;' : 'Object;');
			ret += declString + finalVals.join(';');
		} else {
			ret = declString + 'var ' + v.__otName__ + '=' 
			   + (bIsArray
			       ? OT__EncodeCompactArray(finalVals)
			       : OT__EncodeCompactObject(finalVals));
		}
		delete v.__otInProgress__;
		delete v.__otFullSyntax__;
		return ret;
	} else if (v.__otInProgress__) {
		v.__otFullSyntax__ = true;
		return '';
	}
	return '';
}
function OT__EncodeCompactArray (vs) {
	return '[' + vs.join(',') + ']';
}
function OT__EncodeCompactObject (vs) {
	return '{' + vs.join(',') + '}';
}
function OT__EncodeValue (v) {
	var t = typeof(v);
	switch (t) {
		case 'undefined':
			return 'u';
			break;
		case 'date':
			return OT__EncodeDate((new Date(v)).valueOf());
			break;
		case 'number':
			return v.toString();
			break;
		case 'string':
			return OT__EncodeString(v);
			break;
		case 'boolean':
			return OT__EncodeBoolean(v);
			break;
		case 'object':
			if (v == null) {
				return 'null';
			} else {
				return OT__EncodeConstructed(v);
			}
			break;
		case 'function':
			return OT__EncodeFunction(v);
			break;
		default:
			return OT__EncodeString(name, '(Unknown type)' + t);
			break;
	}
}
function OT__EncodeConstructed(v) {
	if (v == null || typeof(v.constructor) == 'undefined')
		return 'null';
	var t = v.constructor.toString();
	if (t == OT__StringCtor)
		return OT__EncodeString(v);
	if (t == OT__NumberCtor)
		return v.toString();
	if (t == OT__BooleanCtor)
		return OT__EncodeBoolean(v);
	if (t == OT__DateCtor)
		return OT__EncodeDate(v.valueOf());
	/* Assume it's some kinda named object */
	return v.__otName__;
}
function OT__EncodeFunction(v) {
	var funcText = v.toString();
	var paramsRe = /.*\((.*)\)/;
	var results = funcText.match (paramsRe);
	var params = RegExp.$1;
	var i = results["lastIndex"] + 1;
	while (funcText.charAt(i) != '{')
		i++;
	var start = i + 1;
	i = funcText.length - 1;
	while (funcText.charAt(i) != '}')
		i--;
	var end = i - 1;
	var body = funcText.substring(start, end);
	return 'new Function("' + params + '",unescape("' + escape(body) + '"))';
}
function OT__EncodeDate(v) {
	return 'new Date(' + v + ')';
}
function OT__EncodeString(v) {
	var result;
	result = escape(v).replace(/\+/g, '%2B').replace(/\//g, '%2F');
	if (result == v) 
		result = '"' + result + '"'
	else
		result = 'unescape("' + result + '")';
	return result;
}
function OT__EncodeBoolean(v) {
	return v ? 'true' : 'false';
}
function OT__Encode(v) {
	OT__BeginEncoding();
	var dec = OT__EncodeDeclaration(v);
	var val = OT__EncodeValue(v);
	var ret = dec + (dec.length > 0 ? ';' : '') + val;
	OT__EndEncoding(v);
	return ret;
}
///////////////// END CLIENT+SERVER FUNCTIONS ///////////////////
/////////////////////////////////////////////////////////////////



@end
</SCRIPT>

