 <SCRIPT RUNAT=SERVER Language="JavaScript">
//*****************************************************************
// RSO POST Version 1.3 : Michael Garnett (mg01@webpickles.com)
// BASED ON
// MSL : Microsoft Scripting Libary 1.0a
// Remote Scripting utilities for server.
// MODIFIED FOR ObjectTransfer by Michael Garnett (mg01@webpickles.com)
//
//	The Remote Scripting utilities for the server primarily 
//	consists of the RSDispatch routine.  This is the function
//	placed at the top of the ASP page which handles dispatching
//	to a valid public_description function and marshalls the
//	return value back to the client.
//
// Copyright 1999 Microsoft Corporation. All Rights Reserved.
//*****************************************************************

var ENABLE_LOGGING; //Modify value in RSDispatch

function RSGetQueryStringValue(k)
{
	var val;
	if (Request.ServerVariables("REQUEST_METHOD")+""  == "POST")
		val = Request.Form(k)();
	else
		val = Request.QueryString(k)();
	return val;
}

function RSGetParameterValue(k)
{
	var pkg = RSGetQueryStringValue(k);
	if (ENABLE_LOGGING) {
		Response.AppendToLog('\r\n' + k + "='" + pkg + "'");
	}
	// The escaped version of the package (made with otMakeParameter)
	// has already been unescaped by the server. otDecodePackage
	// skips the unescape() step.
	return otDecodePackage(pkg);
}

function RSqesc( thing ){
  if( typeof(thing) != 'string' ) return '';
  var tmp = thing.replace( /"/g, '\\"' ); 
  return tmp.replace( /'/g, "\\'" );
}

//*****************************************************************
// function RSDispatch()
//	This function is used to dispatch to the proper server
//	function in the public_description object based on the
//	Request.QueryString("_method") parameter passed in.
//
//*****************************************************************
function RSDispatch(vtable,methodname)
{
	ENABLE_LOGGING = false;
	if (typeof(methodname) != 'string')
	{
		var methodtype = RSGetQueryStringValue('_mtype') + '';
		if (methodtype != 'execute')
			return false;
		methodname = RSGetQueryStringValue('_method') + '';
		if (methodname == '' || methodname == 'undefined')
			return false;
	}

	var dispatchVTbl = null;
	if (typeof(vtable) == 'object')
		dispatchVTbl = vtable;
	else if (typeof(public_description) == 'object')
		dispatchVTbl = public_description;
	if (dispatchVTbl == null)
		return false;

	var strResponse = '<METHOD VERSION="1.0.8044">'
	if (methodname == 'GetServerProxy') 
	{ 
		strResponse += Return(GetServerProxy(dispatchVTbl));
	}
	else
	{
		if (typeof(dispatchVTbl[methodname]) == 'function' || typeof(dispatchVTbl[methodname]) == 'unknown')
		{	// validate function is in dispatchVTbl
			var pcount = RSGetQueryStringValue('pcount');
			var params = new Array(pcount);
			var paramlist = '';
			for (var i=0; i < pcount; i++)
			{	// extract parameter values
				params[i] = RSGetParameterValue('p' + i );
				if (i > 0)
					paramlist += ',';
				paramlist += 'params[' + i + ']';
			}
			var dispatch = 'dispatchVTbl.' + methodname + '(' + paramlist + ')';
			// Response.write(dispatch);	// USED FOR DEBUG
			// validated against dispatchVTbl, safe to eval on the server
			var r;
			try 
			{
				r = eval(dispatch); 
				strResponse += Return(r);
			}
			catch (e)
			{
				if (typeof(e) == 'object' && e.__RSERROR == true) {
					strResponse += Return(e);
				} else {
					var msg = null, errorValue = e;
					if (typeof(e) == 'string') {
						msg = e;
					} else if (typeof(e) == 'object' && e != null && typeof(e.description) != 'undefined') {
						msg = e.description;
					}
					strResponse += Return(RSError(msg, e));
				}
			}
		}
		else
		{
			strResponse += ReturnError(methodname + ' : not a public function');
		}
	}
	strResponse += '</METHOD>';
	
	Response.Write(strResponse);
	return true;
}

//*****************************************************************
// function Return(x)
//	This function is used to translate the data in given variable x,
//	into a string for transport to the client.  If the variable
//	is an object, then the type is set to EVAL_OBJECT to indicate 
//	to the client that this is an object being marshalled and it 
//	should be "evaluated".  
//*****************************************************************
function Return(x)
{	
	var ret, prefix, suffix = '</RETURN_VALUE>';
	if (x != null && x.__RSERROR == true) {
		// ' (tick) is safe to use as a field separator - 
		// encoded values never contain that character.
		ret = x.__RSMESSAGE + "'" + x.__RSPAYLOAD;
		prefix = '<RETURN_VALUE TYPE=EVAL_ERROR>';
	} else {
		ret = otMakePackage(x);
		prefix = '<RETURN_VALUE TYPE=EVAL_OBJECT>';
	}
	if (ENABLE_LOGGING) {
		Response.AppendToLog("\r\nResult='" + prefix + ret + suffix + "'");
	}
	return prefix + escape(ret) + suffix;
}

function RSError(message, optValue)
{
	return {'__RSERROR'   : true, 
	        '__RSPAYLOAD' : otMakePackage(optValue),
	        '__RSMESSAGE' : otMakePackage(message)};
}

function ReturnError(x)
{
	var strError = '<RETURN_VALUE TYPE=ERROR>';
	strError += escape(x);
	strError += '</RETURN_VALUE>';
	return strError;
}

//*****************************************************************
// function GetServerProxy(pd)
//	This function returns a server proxy given a public_description.
//
//*****************************************************************
function GetServerProxy(pd)
{
	var o = new Object;
	for (var name in pd)
	{
		if (typeof(pd[name]) == 'function')
		{
			o[name] = 0;
		}
		else
		//  Do we have a VBScript object?
		if (typeof(pd[name]) == 'unknown')
		{
			o[name] = 0;
		}	
	}
	return o;
}

</SCRIPT>

<!--#include file="ObjectTransferSupport.asp"-->